<?php
//Lo haces en dos partes porque el webview no borra las cookies de ese pseudo navegador, entonces aquí borras y llevas a
//app-logout que ahí es donde la app cierra sesion, si es por navegador de ahí ya solo es doble redirección a login

// Para borrar la cookie "userId"
if(isset($_COOKIE["userId"])){
    // Establecemos una fecha de expiración pasada
    setcookie("userId", "", time() - 3600, "/");
    // Intenta borrar todas las cookies de wp para que no interfieran con la app por cualquier cosa
    clear_all_cookies_simple();

    //echo "Logged out"; //Que no haga echo para que solo redirija...
}else{
    //echo "Already logged out";//en principio esto nunca se ve... 
}

function clear_all_cookies_simple() {
    //NO ES PERFECTO, solo borra cookies comunes pero debe funcionar...
    $host = $_SERVER["HTTP_HOST"] ?? "";
    $domains = [null]; // null = sin dominio explícito
    if ($host !== "") {
        $domains[] = $host;       // ejemplo.com o sub.ejemplo.com
        $domains[] = ".".$host;   // .ejemplo.com
    }

    foreach ($_COOKIE as $name => $value) {
        // Borrar sin path
        setcookie($name, "", time() - 3600);

        // Borrar en path raíz "/"
        foreach ($domains as $domain) {
            setcookie($name, "", time() - 3600, "/"); // sin dominio
            if ($domain !== null) {
                setcookie($name, "", time() - 3600, "/", $domain);
            }
        }
    }
}

//Adicional que tambien cierre sesión en WP por si llegas desde WP...
require_once("wp-load.php");
wp_logout();
wp_redirect(site_url("/app-logout.php"));
exit;

?>